( function ( $ ) {
	'use strict';

	var nanLatnPehoejiTransliteration = {
		id: 'nan-latn-pehoeji-transliteration',
		name: '閩南語白話字IME / Bân-lâm-gí Pe̍h-ōe-jī IME',
		description: 'Hokkien Pe̍h-ōe-jī Transliteration input method',
		date: '2024-11-19',
		URL: 'https://www.mediawiki.org/wiki/Special:MyLanguage/Help:Extension:UniversalLanguageSelector/Input_methods/nan-latn-pehoeji-transliteration',
		author: 'Winston Sung',
		license: 'MIT',
		version: '1.4',
		maxKeyLength: 5,
		patterns: [
			[ 'nn', 'ⁿ' ],
			[ 'hnn', 'hⁿ' ],
			[ 'nnh', 'hⁿ' ],
			[ 'ⁿh', 'hⁿ' ],
			[ 'ⁿg', 'nng' ],
			[ '(^|[^ioIO])a(ⁿ|iⁿ?|m|ng?|u)?1', '$1a$2' ],
			[ '(^|[^ioIO])a(ⁿ|iⁿ?|m|ng?|u)?2', '$1á$2' ],
			[ '(^|[^ioIO])a(ⁿ|iⁿ?|m|ng?|u)?3', '$1à$2' ],
			[ '(^|[^ioIO])a(p|t|k|hⁿ?)4', '$1a$2' ],
			[ '(^|[^ioIO])auh4', '$1auh' ],
			[ '(^|[^ioIO])a(ⁿ|iⁿ?|m|ng?|u)?5', '$1â$2' ],
			[ '(^|[^ioIO])a(ⁿ|iⁿ?|m|ng?|u)?6', '$1ã$2' ],
			[ '(^|[^ioIO])a(ⁿ|iⁿ?|m|ng?|u)?7', '$1ā$2' ],
			[ '(^|[^ioIO])a(p|t|k|hⁿ?)8', '$1a̍$2' ],
			[ '(^|[^ioIO])auh8', '$1au̍h' ],
			[ '(^|[^ioIO])a(ⁿ|iⁿ?|m|ng?|u)?9', '$1ă$2' ],
			[ '(^|[^ioIO])a(p|t|k|hⁿ?)9', '$1ă$2' ],
			[ '(^|[^ioIO])auh9', '$1aŭh' ],
			[ '(^|[^oO])e(ⁿ|ng)?1', '$1e$2' ],
			[ '(^|[^oO])e(ⁿ|ng)?2', '$1é$2' ],
			[ '(^|[^oO])e(ⁿ|ng)?3', '$1è$2' ],
			[ '(^|[^oO])e(hⁿ?|k)4', '$1e$2' ],
			[ '(^|[^oO])e(ⁿ|ng)?5', '$1ê$2' ],
			[ '(^|[^oO])e(ⁿ|ng)?6', '$1ẽ$2' ],
			[ '(^|[^oO])e(ⁿ|ng)?7', '$1ē$2' ],
			[ '(^|[^oO])e(hⁿ?|k)8', '$1e̍$2' ],
			[ '(^|[^oO])e(ⁿ|ng)?9', '$1ĕ$2' ],
			[ '(^|[^oO])e(hⁿ?|k)9', '$1ĕ$2' ],
			[ 'ia(ⁿ?|m|ng?|uⁿ?)?1', 'ia$1' ],
			[ '(^|[^auAU])i(ⁿ|m|n)?1', '$1i$2' ],
			[ '(^|[^auAU])iu(ⁿ)?1', '$1iu$2' ],
			[ 'io(ng)?1', 'io$1' ],
			[ 'ia(ⁿ?|m|ng?|uⁿ?)?2', 'iá$1' ],
			[ '(^|[^auAU])i(ⁿ|m|n)?2', '$1í$2' ],
			[ '(^|[^auAU])iu(ⁿ)?2', '$1iú$2' ],
			[ 'io(ng)?2', 'ió$1' ],
			[ 'ia(ⁿ?|m|ng?|uⁿ?)?3', 'ià$1' ],
			[ '(^|[^auAU])i(ⁿ|m|n)?3', '$1ì$2' ],
			[ '(^|[^auAU])iu(ⁿ)?3', '$1iù$2' ],
			[ 'io(ng)?3', 'iò$1' ],
			[ 'ia(hⁿ?|k|p|t)4', 'ia$1' ],
			[ '(^|[^auAU])i(h|p|t)4', '$1i$2' ],
			[ 'io(h|k)4', 'io$1' ],
			[ 'iauh4', 'iauh' ],
			[ 'iuh(ⁿ)?4', 'iuh$1' ],
			[ 'ia(ⁿ?|m|ng?|uⁿ?)?5', 'iâ$1' ],
			[ '(^|[^auAU])i(ⁿ|m|n)?5', '$1î$2' ],
			[ '(^|[^auAU])iu(ⁿ)?5', '$1iû$2' ],
			[ 'io(ng)?5', 'iô$1' ],
			[ 'ia(ⁿ?|m|ng?|uⁿ?)?6', 'iã$1' ],
			[ '(^|[^auAU])i(ⁿ|m|n)?6', '$1ĩ$2' ],
			[ '(^|[^auAU])iu(ⁿ)?6', '$1iũ$2' ],
			[ 'io(ng)?6', 'iõ$1' ],
			[ 'ia(ⁿ?|m|ng?|uⁿ?)?7', 'iā$1' ],
			[ '(^|[^auAU])i(ⁿ|m|n)?7', '$1ī$2' ],
			[ '(^|[^auAU])iu(ⁿ)?7', '$1iū$2' ],
			[ 'io(ng)?7', 'iō$1' ],
			[ 'ia(hⁿ?|k|p|t)8', 'ia̍$1' ],
			[ '(^|[^auAU])i(h|p|t)8', '$1i̍$2' ],
			[ 'io(h|k)8', 'io̍$1' ],
			[ 'iauh8', 'iau̍h' ],
			[ 'iuh(ⁿ)?8', 'iu̍h$1' ],
			[ 'ia(ⁿ?|m|ng?|uⁿ?)?9', 'iă$1' ],
			[ '(^|[^auAU])i(ⁿ|m|n)?9', '$1ĭ$2' ],
			[ '(^|[^auAU])iu(ⁿ)?9', '$1iŭ$2' ],
			[ 'io(ng)?9', 'iŏ$1' ],
			[ 'ia(hⁿ?|k|p|t)9', 'iă$1' ],
			[ '(^|[^auAU])i(h|p|t)9', '$1ĭ$2' ],
			[ 'io(h|k)9', 'iŏ$1' ],
			[ 'iauh9', 'iaŭh' ],
			[ 'iuh(ⁿ)?9', 'iŭh$1' ],
			[ '(^|[^aioAIO])m1', '$1m' ],
			[ '(^|[^aioAIO])m2', '$1ḿ' ],
			[ '(^|[^aioAIO])m3', '$1m̀' ],
			[ '(^|[^aioAIO])mh4', '$1mh' ],
			[ '(^|[^aioAIO])m5', '$1m̂' ],
			[ '(^|[^aioAIO])m6', '$1m̃' ],
			[ '(^|[^aioAIO])m7', '$1m̄' ],
			[ '(^|[^aioAIO])mh8', '$1m̍h' ],
			[ '(^|[^aioAIO])m9', '$1m̆' ],
			[ '(^|[^aioAIO])mh9', '$1m̆h' ],
			[ '(^|[^aeoAEO])ng1', '$1ng' ],
			[ '(^|[^aeoAEO])ng2', '$1ńg' ],
			[ '(^|[^aeoAEO])ng3', '$1ǹg' ],
			[ '(^|[^aeoAEO])n(g)?h4', '$1n$2h' ],
			[ '(^|[^aeoAEO])ng5', '$1n̂g' ],
			[ '(^|[^aeoAEO])ng6', '$1ñg' ],
			[ '(^|[^aeoAEO])ng7', '$1n̄g' ],
			[ '(^|[^aeoAEO])n(g)?h8', '$1n̍$2h' ],
			[ '(^|[^aeoAEO])ng9', '$1n̆g' ],
			[ '(^|[^aeoAEO])n(g)?h9', '$1n̆$2h' ],
			[ '(^|[^iI])oa(iⁿ?|ng?)1', '$1oa$2' ],
			[ '(^|[^iI])o(ⁿ|aⁿ?|e|m|ng)?1', '$1o$2' ],
			[ '(^|[^iI])oa(iⁿ?|ng?)2', '$1oá$2' ],
			[ '(^|[^iI])o(ⁿ|aⁿ?|e|m|ng)?2', '$1ó$2' ],
			[ '(^|[^iI])oa(iⁿ?|ng?)3', '$1oà$2' ],
			[ '(^|[^iI])o(ⁿ|aⁿ?|e|m|ng)?3', '$1ò$2' ],
			[ '(^|[^iI])o(hⁿ?|k)4', '$1o$2' ],
			[ '(^|[^iI])oa(h|t)4', '$1oa$2' ],
			[ '(^|[^iI])oeh4', '$1oeh' ],
			[ '(^|[^iI])oa(iⁿ?|ng?)5', '$1oâ$2' ],
			[ '(^|[^iI])o(ⁿ|aⁿ?|e|m|ng)?5', '$1ô$2' ],
			[ '(^|[^iI])oa(iⁿ?|ng?)6', '$1oã$2' ],
			[ '(^|[^iI])o(ⁿ|aⁿ?|e|m|ng)?6', '$1õ$2' ],
			[ '(^|[^iI])oa(iⁿ?|ng?)7', '$1oā$2' ],
			[ '(^|[^iI])o(ⁿ|aⁿ?|e|m|ng)?7', '$1ō$2' ],
			[ '(^|[^iI])o(hⁿ?|k)8', '$1o̍$2' ],
			[ '(^|[^iI])oa(h|t)8', '$1oa̍$2' ],
			[ '(^|[^iI])oeh8', '$1oe̍h' ],
			[ '(^|[^iI])oa(iⁿ?|ng?)9', '$1oă$2' ],
			[ '(^|[^iI])o(ⁿ|aⁿ?|e|m|ng)?9', '$1ŏ$2' ],
			[ '(^|[^iI])o(hⁿ?|k)9', '$1ŏ$2' ],
			[ '(^|[^iI])oa(h|t)9', '$1oă$2' ],
			[ '(^|[^iI])oeh9', '$1oĕh' ],
			[ 'oo', 'o͘' ],
			[ 'o͘1', 'o͘' ],
			[ 'o͘2', 'ó͘' ],
			[ 'óo', 'ó͘' ],
			[ 'o͘3', 'ò͘' ],
			[ 'òo', 'ò͘' ],
			[ 'o͘h4', 'o͘h' ],
			[ 'o͘5', 'ô͘' ],
			[ 'ôo', 'ô͘' ],
			[ 'o͘6', 'õ͘' ],
			[ 'õo', 'õ͘' ],
			[ 'o͘7', 'ō͘' ],
			[ 'ōo', 'ō͘' ],
			[ 'o͘h8', 'o̍͘h' ],
			[ 'o̍o', 'o̍͘' ],
			[ 'o͘9', 'ŏ͘' ],
			[ 'ŏo', 'ŏ͘' ],
			[ 'o͘h9', 'ŏ͘h' ],
			[ '(^|[^aiAI])u(i|n)?1', '$1u$2' ],
			[ '(^|[^aiAI])u(i|n)?2', '$1ú$2' ],
			[ '(^|[^aiAI])u(i|n)?3', '$1ù$2' ],
			[ '(^|[^aiAI])u(h|t)4', '$1u$2' ],
			[ '(^|[^aiAI])u(i|n)?5', '$1û$2' ],
			[ '(^|[^aiAI])u(i|n)?6', '$1ũ$2' ],
			[ '(^|[^aiAI])u(i|n)?7', '$1ū$2' ],
			[ '(^|[^aiAI])u(h|t)8', '$1u̍$2' ],
			[ '(^|[^aiAI])u(i|n)?9', '$1ŭ$2' ],
			[ '(^|[^aiAI])u(h|t)9', '$1ŭ$2' ],
			[ '(^|[^ioIO])A(ⁿ|iⁿ?|m|ng?|u)?1', '$1A$2' ],
			[ '(^|[^ioIO])A(ⁿ|iⁿ?|m|ng?|u)?2', '$1Á$2' ],
			[ '(^|[^ioIO])A(ⁿ|iⁿ?|m|ng?|u)?3', '$1À$2' ],
			[ '(^|[^ioIO])A(p|t|k|hⁿ?)4', '$1A$2' ],
			[ '(^|[^ioIO])Auh4', '$1Auh' ],
			[ '(^|[^ioIO])A(ⁿ|iⁿ?|m|ng?|u)?5', '$1Â$2' ],
			[ '(^|[^ioIO])A(ⁿ|iⁿ?|m|ng?|u)?6', '$1Ã$2' ],
			[ '(^|[^ioIO])A(ⁿ|iⁿ?|m|ng?|u)?7', '$1Ā$2' ],
			[ '(^|[^ioIO])A(p|t|k|hⁿ?)8', '$1A̍$2' ],
			[ '(^|[^ioIO])Auh4', '$1Au̍h' ],
			[ '(^|[^ioIO])A(ⁿ|iⁿ?|m|ng?|u)?9', '$1Ă$2' ],
			[ '(^|[^ioIO])A(p|t|k|hⁿ?)9', '$1Ă$2' ],
			[ '(^|[^ioIO])Auh4', '$1Aŭh' ],
			[ '(^|[^oO])E(ⁿ|ng)?1', '$1E$2' ],
			[ '(^|[^oO])E(ⁿ|ng)?2', '$1É$2' ],
			[ '(^|[^oO])E(ⁿ|ng)?3', '$1È$2' ],
			[ '(^|[^oO])E(hⁿ?|k)4', '$1E$2' ],
			[ '(^|[^oO])E(ⁿ|ng)?5', '$1Ê$2' ],
			[ '(^|[^oO])E(ⁿ|ng)?6', '$1Ẽ$2' ],
			[ '(^|[^oO])E(ⁿ|ng)?7', '$1Ē$2' ],
			[ '(^|[^oO])E(hⁿ?|k)8', '$1E̍$2' ],
			[ '(^|[^oO])E(ⁿ|ng)?9', '$1Ĕ$2' ],
			[ '(^|[^oO])E(hⁿ?|k)9', '$1Ĕ$2' ],
			[ 'Ia(ⁿ?|m|ng?|uⁿ?)?1', 'Ia$1' ],
			[ '(^|[^auAU])I(ⁿ|m|n)?1', '$1I$2' ],
			[ '(^|[^auAU])Iu(ⁿ)?1', '$1Iu$2' ],
			[ 'Io(ng)?1', 'Io$1' ],
			[ 'Ia(ⁿ?|m|ng?|uⁿ?)?2', 'Iá$1' ],
			[ '(^|[^auAU])I(ⁿ|m|n)?2', '$1Í$2' ],
			[ '(^|[^auAU])Iu(ⁿ)?2', '$1Iú$2' ],
			[ 'Io(ng)?2', 'Ió$1' ],
			[ 'Ia(ⁿ?|m|ng?|uⁿ?)?3', 'Ià$1' ],
			[ '(^|[^auAU])I(ⁿ|m|n)?3', '$1Ì$2' ],
			[ '(^|[^auAU])Iu(ⁿ)?3', '$1Iù$2' ],
			[ 'Io(ng)?3', 'Iò$1' ],
			[ 'Ia(hⁿ?|k|p|t)4', 'Ia$1' ],
			[ '(^|[^auAU])I(h|p|t)4', '$1I$2' ],
			[ 'Io(h|k)4', 'Io$1' ],
			[ 'Iauh4', 'Iauh' ],
			[ 'Iuh(ⁿ)?4', 'Iuh$1' ],
			[ 'Ia(ⁿ?|m|ng?|uⁿ?)?5', 'Iâ$1' ],
			[ '(^|[^auAU])I(ⁿ|m|n)?5', '$1Î$2' ],
			[ '(^|[^auAU])Iu(ⁿ)?5', '$1Iû$2' ],
			[ 'Io(ng)?5', 'Iô$1' ],
			[ 'Ia(ⁿ?|m|ng?|uⁿ?)?6', 'Iã$1' ],
			[ '(^|[^auAU])I(ⁿ|m|n)?6', '$1Ĩ$2' ],
			[ '(^|[^auAU])Iu(ⁿ)?6', '$1Iũ$2' ],
			[ 'Io(ng)?6', 'Iõ$1' ],
			[ 'Ia(ⁿ?|m|ng?|uⁿ?)?7', 'Iā$1' ],
			[ '(^|[^auAU])I(ⁿ|m|n)?7', '$1Ī$2' ],
			[ '(^|[^auAU])Iu(ⁿ)?7', '$1Iū$2' ],
			[ 'Io(ng)?7', 'Iō$1' ],
			[ 'Ia(hⁿ?|k|p|t)8', 'Ia̍$1' ],
			[ '(^|[^auAU])I(h|p|t)8', '$1I̍$2' ],
			[ 'Io(h|k)8', 'Io̍$1' ],
			[ 'Iauh8', 'Iau̍h' ],
			[ 'Iuh(ⁿ)?8', 'Iu̍h$1' ],
			[ 'Ia(ⁿ?|m|ng?|uⁿ?)?9', 'Iă$1' ],
			[ '(^|[^auAU])I(ⁿ|m|n)?9', '$1Ĭ$2' ],
			[ '(^|[^auAU])Iu(ⁿ)?9', '$1Iŭ$2' ],
			[ 'Io(ng)?9', 'Iŏ$1' ],
			[ 'Ia(hⁿ?|k|p|t)9', 'Iă$1' ],
			[ '(^|[^auAU])I(h|p|t)9', '$1Ĭ$2' ],
			[ 'Io(h|k)9', 'Iŏ$1' ],
			[ 'Iauh9', 'Iaŭh' ],
			[ 'Iuh(ⁿ)?9', 'Iŭh$1' ],
			[ '(^|[^aioAIO])M1', '$1M' ],
			[ '(^|[^aioAIO])M2', '$1Ḿ' ],
			[ '(^|[^aioAIO])M3', '$1M̀' ],
			[ '(^|[^aioAIO])Mh4', '$1Mh' ],
			[ '(^|[^aioAIO])M5', '$1M̂' ],
			[ '(^|[^aioAIO])M6', '$1M̃' ],
			[ '(^|[^aioAIO])M7', '$1M̄' ],
			[ '(^|[^aioAIO])Mh8', '$1M̍h' ],
			[ '(^|[^aioAIO])M9', '$1M̆' ],
			[ '(^|[^aioAIO])Mh9', '$1M̆h' ],
			[ '(^|[^aeoAEO])Ng1', '$1Ng' ],
			[ '(^|[^aeoAEO])Ng2', '$1Ńg' ],
			[ '(^|[^aeoAEO])Ng3', '$1Ǹg' ],
			[ '(^|[^aeoAEO])N(g)?h4', '$1N$2h' ],
			[ '(^|[^aeoAEO])Ng5', '$1N̂g' ],
			[ '(^|[^aeoAEO])Ng6', '$1Ñg' ],
			[ '(^|[^aeoAEO])Ng7', '$1N̄g' ],
			[ '(^|[^aeoAEO])N(g)?h8', '$1N̍$2h' ],
			[ '(^|[^aeoAEO])Ng9', '$1N̆g' ],
			[ '(^|[^aeoAEO])N(g)?h9', '$1N̆$2h' ],
			[ '(^|[^iI])Oa(iⁿ?|ng?)1', '$1Oa$2' ],
			[ '(^|[^iI])O(ⁿ|aⁿ?|e|m|ng)?1', '$1O$2' ],
			[ '(^|[^iI])Oa(iⁿ?|ng?)2', '$1Oá$2' ],
			[ '(^|[^iI])O(ⁿ|aⁿ?|e|m|ng)?2', '$1Ó$2' ],
			[ '(^|[^iI])Oa(iⁿ?|ng?)3', '$1Oà$2' ],
			[ '(^|[^iI])O(ⁿ|aⁿ?|e|m|ng)?3', '$1Ò$2' ],
			[ '(^|[^iI])O(hⁿ?|k)4', '$1O$2' ],
			[ '(^|[^iI])Oa(h|t)4', '$1Oa$2' ],
			[ '(^|[^iI])Oeh4', '$1Oeh' ],
			[ '(^|[^iI])Oa(iⁿ?|ng?)5', '$1Oâ$2' ],
			[ '(^|[^iI])O(ⁿ|aⁿ?|e|m|ng)?5', '$1Ô$2' ],
			[ '(^|[^iI])Oa(iⁿ?|ng?)6', '$1Oã$2' ],
			[ '(^|[^iI])O(ⁿ|aⁿ?|e|m|ng)?6', '$1Õ$2' ],
			[ '(^|[^iI])Oa(iⁿ?|ng?)7', '$1Oā$2' ],
			[ '(^|[^iI])O(ⁿ|aⁿ?|e|m|ng)?7', '$1Ō$2' ],
			[ '(^|[^iI])O(hⁿ?|k)8', '$1O̍$2' ],
			[ '(^|[^iI])Oa(h|t)8', '$1Oa̍$2' ],
			[ '(^|[^iI])Oeh8', '$1Oe̍h' ],
			[ '(^|[^iI])Oa(iⁿ?|ng?)9', '$1Oă$2' ],
			[ '(^|[^iI])O(ⁿ|aⁿ?|e|m|ng)?9', '$1Ŏ$2' ],
			[ '(^|[^iI])O(hⁿ?|k)9', '$1Ŏ$2' ],
			[ '(^|[^iI])Oa(h|t)9', '$1Oă$2' ],
			[ '(^|[^iI])Oeh9', '$1Oĕh' ],
			[ 'Oo', 'O͘' ],
			[ 'O͘1', 'O͘' ],
			[ 'O͘2', 'Ó͘' ],
			[ 'Óu', 'Ó͘' ],
			[ 'O͘3', 'Ò͘' ],
			[ 'Òo', 'Ò͘' ],
			[ 'O͘h4', 'O͘h' ],
			[ 'O͘5', 'Ô͘' ],
			[ 'Ôo', 'Ô͘' ],
			[ 'O͘6', 'Õ͘' ],
			[ 'Õo', 'Õ͘' ],
			[ 'O͘7', 'Ō͘' ],
			[ 'Ōo', 'Ō͘' ],
			[ 'O͘h8', 'O̍͘h' ],
			[ 'O̍o', 'O̍͘' ],
			[ 'O͘9', 'Ŏ͘' ],
			[ 'Ŏo', 'Ŏ͘' ],
			[ 'O͘h9', 'Ŏ͘h' ],
			[ '(^|[^aiAI])U(i|n)?1', '$1U$2' ],
			[ '(^|[^aiAI])U(i|n)?2', '$1Ú$2' ],
			[ '(^|[^aiAI])U(i|n)?3', '$1Ù$2' ],
			[ '(^|[^aiAI])U(h|t)4', '$1U$2' ],
			[ '(^|[^aiAI])U(i|n)?5', '$1Û$2' ],
			[ '(^|[^aiAI])U(i|n)?6', '$1Ũ$2' ],
			[ '(^|[^aiAI])U(i|n)?7', '$1Ū$2' ],
			[ '(^|[^aiAI])U(h|t)8', '$1U̍$2' ],
			[ '(^|[^aiAI])U(i|n)?9', '$1Ŭ$2' ],
			[ '(^|[^aiAI])U(h|t)9', '$1Ŭ$2' ],
			[ 'NN', 'ᴺ' ],
			[ 'HNN', 'Hᴺ' ],
			[ 'NNH', 'Hᴺ' ],
			[ 'ᴺH', 'Hᴺ' ],
			[ 'ᴺG', 'NNG' ],
			[ '(^|[^ioIO])A(ᴺ|Iᴺ?|M|NG?|U)?1', '$1A$2' ],
			[ '(^|[^ioIO])A(ᴺ|Iᴺ?|M|NG?|U)?2', '$1Á$2' ],
			[ '(^|[^ioIO])A(ᴺ|Iᴺ?|M|NG?|U)?3', '$1À$2' ],
			[ '(^|[^ioIO])A(P|T|K|Hᴺ?)4', '$1A$2' ],
			[ '(^|[^ioIO])AUH4', '$1AUH' ],
			[ '(^|[^ioIO])A(ᴺ|Iᴺ?|M|NG?|U)?5', '$1Â$2' ],
			[ '(^|[^ioIO])A(ᴺ|Iᴺ?|M|NG?|U)?6', '$1Ã$2' ],
			[ '(^|[^ioIO])A(ᴺ|Iᴺ?|M|NG?|U)?7', '$1Ā$2' ],
			[ '(^|[^ioIO])A(P|T|K|Hᴺ?)8', '$1A̍$2' ],
			[ '(^|[^ioIO])AUH8', '$1AU̍H' ],
			[ '(^|[^ioIO])A(ᴺ|Iᴺ?|M|NG?|U)?9', '$1Ă$2' ],
			[ '(^|[^ioIO])A(P|T|K|Hᴺ?)9', '$1Ă$2' ],
			[ '(^|[^ioIO])AUH9', '$1AŬH' ],
			[ '(^|[^oO])E(ᴺ|NG)?1', '$1E$2' ],
			[ '(^|[^oO])E(ᴺ|NG)?2', '$1É$2' ],
			[ '(^|[^oO])E(ᴺ|NG)?3', '$1È$2' ],
			[ '(^|[^oO])E(Hᴺ?|K)4', '$1E$2' ],
			[ '(^|[^oO])E(ᴺ|NG)?5', '$1Ê$2' ],
			[ '(^|[^oO])E(ᴺ|NG)?6', '$1Ẽ$2' ],
			[ '(^|[^oO])E(ᴺ|NG)?7', '$1Ē$2' ],
			[ '(^|[^oO])E(Hᴺ?|K)8', '$1E̍$2' ],
			[ '(^|[^oO])E(ᴺ|NG)?9', '$1Ĕ$2' ],
			[ '(^|[^oO])E(Hᴺ?|K)9', '$1Ĕ$2' ],
			[ 'IA(ᴺ?|M|NG?|Uᴺ?)?1', 'IA$1' ],
			[ '(^|[^auAU])I(ᴺ|M|N)?1', '$1I$2' ],
			[ '(^|[^auAU])IU(ᴺ)?1', '$1IU$2' ],
			[ 'IO(NG)?1', 'IO$1' ],
			[ 'IA(ᴺ?|M|NG?|Uᴺ?)?2', 'IÁ$1' ],
			[ '(^|[^auAU])I(ᴺ|M|N)?2', '$1Í$2' ],
			[ '(^|[^auAU])IU(ᴺ)?2', '$1IÚ$2' ],
			[ 'IO(NG)?2', 'IÓ$1' ],
			[ 'IA(ᴺ?|M|NG?|Uᴺ?)?3', 'IÀ$1' ],
			[ '(^|[^auAU])I(ᴺ|M|N)?3', '$1Ì$2' ],
			[ '(^|[^auAU])IU(ᴺ)?3', '$1IÙ$2' ],
			[ 'IO(NG)?3', 'IÒ$1' ],
			[ 'IA(Hᴺ?|K|P|T)4', 'IA$1' ],
			[ '(^|[^auAU])I(H|P|T)4', '$1I$2' ],
			[ 'IO(H|K)4', 'IO$1' ],
			[ 'IAUH4', 'IAUH' ],
			[ 'IUH(ᴺ)?4', 'IUH$1' ],
			[ 'IA(ᴺ?|M|NG?|Uᴺ?)?5', 'IÂ$1' ],
			[ '(^|[^auAU])I(ᴺ|M|N)?5', '$1Î$2' ],
			[ '(^|[^auAU])IU(ᴺ)?5', '$1IÛ$2' ],
			[ 'IO(NG)?5', 'IÔ$1' ],
			[ 'IA(ᴺ?|M|NG?|Uᴺ?)?6', 'IÃ$1' ],
			[ '(^|[^auAU])I(ᴺ|M|N)?6', '$1Ĩ$2' ],
			[ '(^|[^auAU])IU(ᴺ)?6', '$1IŨ$2' ],
			[ 'IO(NG)?6', 'IÕ$1' ],
			[ 'IA(ᴺ?|M|NG?|Uᴺ?)?7', 'IĀ$1' ],
			[ '(^|[^auAU])I(ᴺ|M|N)?7', '$1Ī$2' ],
			[ '(^|[^auAU])IU(ᴺ)?7', '$1IŪ$2' ],
			[ 'IO(NG)?7', 'IŌ$1' ],
			[ 'IA(Hᴺ?|K|P|T)8', 'IA̍$1' ],
			[ '(^|[^auAU])I(H|P|T)8', '$1I̍$2' ],
			[ 'IO(H|K)8', 'IO̍$1' ],
			[ 'IAUH8', 'IAU̍H' ],
			[ 'IUH(ᴺ)?8', 'IU̍H$1' ],
			[ 'IA(ᴺ?|M|NG?|Uᴺ?)?9', 'IĂ$1' ],
			[ '(^|[^auAU])I(ᴺ|M|N)?9', '$1Ĭ$2' ],
			[ '(^|[^auAU])IU(ᴺ)?9', '$1IŬ$2' ],
			[ 'IO(NG)?9', 'IŎ$1' ],
			[ 'IA(Hᴺ?|K|P|T)9', 'IĂ$1' ],
			[ '(^|[^auAU])I(H|P|T)9', '$1Ĭ$2' ],
			[ 'IO(H|K)9', 'IŎ$1' ],
			[ 'IAUH9', 'IAŬH' ],
			[ 'IUH(ᴺ)?9', 'IŬH$1' ],
			[ '(^|[^aoAO])M1', '$1M' ],
			[ '(^|[^aioAIO])M2', '$1Ḿ' ],
			[ '(^|[^aioAIO])M3', '$1M̀' ],
			[ '(^|[^aioAIO])MH4', '$1MH' ],
			[ '(^|[^aioAIO])M5', '$1M̂' ],
			[ '(^|[^aioAIO])M6', '$1M̃' ],
			[ '(^|[^aioAIO])M7', '$1M̄' ],
			[ '(^|[^aioAIO])MH8', '$1M̍H' ],
			[ '(^|[^aioAIO])M9', '$1M̆' ],
			[ '(^|[^aioAIO])MH9', '$1M̆H' ],
			[ '(^|[^aeoAEO])NG1', '$1NG' ],
			[ '(^|[^aeoAEO])NG2', '$1ŃG' ],
			[ '(^|[^aeoAEO])NG3', '$1ǸG' ],
			[ '(^|[^aeoAEO])N(G)?H4', '$1N$2H' ],
			[ '(^|[^aeoAEO])NG5', '$1N̂G' ],
			[ '(^|[^aeoAEO])NG6', '$1ÑG' ],
			[ '(^|[^aeoAEO])NG7', '$1N̄G' ],
			[ '(^|[^aeoAEO])N(G)?H8', '$1N̍$2H' ],
			[ '(^|[^aeoAEO])NG9', '$1N̆G' ],
			[ '(^|[^aeoAEO])N(G)?H9', '$1N̆$2H' ],
			[ '(^|[^iI])OA(Iᴺ?|NG?)1', '$1OA$2' ],
			[ '(^|[^iI])O(ᴺ|Aᴺ?|E|M|NG)?1', '$1O$2' ],
			[ '(^|[^iI])OA(Iᴺ?|NG?)2', '$1OÁ$2' ],
			[ '(^|[^iI])O(ᴺ|Aᴺ?|E|M|NG)?2', '$1Ó$2' ],
			[ '(^|[^iI])OA(Iᴺ?|NG?)3', '$1OÀ$2' ],
			[ '(^|[^iI])O(ᴺ|Aᴺ?|E|M|NG)?3', '$1Ò$2' ],
			[ '(^|[^iI])O(Hᴺ?|K)4', '$1O$2' ],
			[ '(^|[^iI])OA(H|T)4', '$1OA$2' ],
			[ '(^|[^iI])OEH4', '$1OEH' ],
			[ '(^|[^iI])OA(Iᴺ?|NG?)5', '$1OÂ$2' ],
			[ '(^|[^iI])O(ᴺ|Aᴺ?|E|M|NG)?5', '$1Ô$2' ],
			[ '(^|[^iI])OA(Iᴺ?|NG?)6', '$1OÃ$2' ],
			[ '(^|[^iI])O(ᴺ|Aᴺ?|E|M|NG)?6', '$1Õ$2' ],
			[ '(^|[^iI])OA(Iᴺ?|NG?)7', '$1OĀ$2' ],
			[ '(^|[^iI])O(ᴺ|Aᴺ?|E|M|NG)?7', '$1Ō$2' ],
			[ '(^|[^iI])O(Hᴺ?|K)8', '$1O̍$2' ],
			[ '(^|[^iI])OA(H|T)8', '$1OA̍$2' ],
			[ '(^|[^iI])OEH8', '$1OE̍H' ],
			[ '(^|[^iI])OA(Iᴺ?|NG?)9', '$1OĂ$2' ],
			[ '(^|[^iI])O(ᴺ|Aᴺ?|E|M|NG)?9', '$1Ŏ$2' ],
			[ '(^|[^iI])O(Hᴺ?|K)9', '$1Ŏ$2' ],
			[ '(^|[^iI])OA(H|T)9', '$1OĂ$2' ],
			[ '(^|[^iI])OEH9', '$1OĔH' ],
			[ 'OO', 'O͘' ],
			[ 'O͘1', 'O͘' ],
			[ 'O͘2', 'Ó͘' ],
			[ 'Óo', 'Ó͘' ],
			[ 'O͘3', 'Ò͘' ],
			[ 'ÒO', 'Ò͘' ],
			[ 'O͘H4', 'O͘H' ],
			[ 'O͘5', 'Ô͘' ],
			[ 'ÔO', 'Ô͘' ],
			[ 'O͘6', 'Õ͘' ],
			[ 'ÕO', 'Õ͘' ],
			[ 'O͘7', 'Ō͘' ],
			[ 'ŌO', 'Ō͘' ],
			[ 'O͘H8', 'O̍͘H' ],
			[ 'O̍O', 'O̍͘' ],
			[ 'O͘9', 'Ŏ͘' ],
			[ 'ŎO', 'Ŏ͘' ],
			[ 'O͘H9', 'Ŏ͘H' ],
			[ '(^|[^aiAI])U(I|N)?1', '$1U$2' ],
			[ '(^|[^aiAI])U(I|N)?2', '$1Ú$2' ],
			[ '(^|[^aiAI])U(I|N)?3', '$1Ù$2' ],
			[ '(^|[^aiAI])U(H|T)4', '$1U$2' ],
			[ '(^|[^aiAI])U(I|N)?5', '$1Û$2' ],
			[ '(^|[^aiAI])U(I|N)?6', '$1Ũ$2' ],
			[ '(^|[^aiAI])U(I|N)?7', '$1Ū$2' ],
			[ '(^|[^aiAI])U(H|T)8', '$1U̍$2' ],
			[ '(^|[^aiAI])U(I|N)?9', '$1Ŭ$2' ],
			[ '(^|[^aiAI])U(H|T)9', '$1Ŭ$2' ],
		]
	};

	$.ime.register( nanLatnPehoejiTransliteration );
}( jQuery ) );
